@echo off
echo Git updates disabled.
exit /b 0

SETLOCAL ENABLEEXTENSIONS
SETLOCAL ENABLEDELAYEDEXPANSION

SET ESC=[
SET ESC_CLEAR=%ESC%2j
SET ESC_RESET=%ESC%0m
SET ESC_GREEN=%ESC%32m
SET ESC_RED=%ESC%31m
SET ESC_YELLOW=%ESC%33m

if [%1] EQU [] (
    rem No param, use master branch
    SET GIT_BRANCH=master

) else (
    rem Param provided, use it as the current branch
    SET GIT_BRANCH=%1
    echo using git branch %GIT_BRANCH%
)

rem Base folder is passed in when after it gets copied to the temp location so
rem it knows where to target git commands
if [%2] EQU [] (
    SET BASE_FOLDER=%~dp0
) else (
    SET BASE_FOLDER=%2
)

REM Define the registry key and value name
set "key=HKLM\Software\Ope"
set "value=smc_url"
REM Query the registry and store the result in a variable
for /f "tokens=2*" %%A in ('reg query "%key%" /v "%value%" 2^>nul') do (
    set "reg_value=%%B"
)

REM Check if the variable is set (i.e., the value was found)
if defined reg_value (
    rem echo The registry value is: %reg_value%
) else (
    rem echo Registry value not found.
	set "reg_value=https://smc.ed"
)

REM Replace "https" with "git"
set SMC_GIT=%reg_value:https=git%
rem set "new_string=%original_string:foo=bar%"

echo Using SMC URL: %SMC_GIT%


rem Need to copy git files to a temp location
set GIT_TEMP=%windir%\Temp\Git\
set GIT_PATH=%GIT_TEMP%bin\git.exe
rem make sure folder exists
md %GIT_TEMP% 1>NUL 2>NUL

rem /Q for quiet, /F for full
SET QUIET_FLAG=/Q

echo %~dp0 %BASE_FOLDER% %GIT_TEMP%
if /I NOT "%~dp0"=="%GIT_TEMP%" (
    echo Copying To Temp Location... %BASE_FOLDER% to %GIT_TEMP%
    echo f | xcopy /FY "%BASE_FOLDER%PullUpdates.cmd" "%GIT_TEMP%PullUpdates.cmd" 1>NUL 2>NUL
    rem Copy git files over to temp folder
    xcopy /ECIHRKY %QUIET_FLAG% "%BASE_FOLDER%bin\*" "%GIT_TEMP%bin\"
    xcopy /ECIHRKY %QUIET_FLAG% "%BASE_FOLDER%cmd\*" "%GIT_TEMP%cmd\"
    xcopy /ECIHRKY %QUIET_FLAG% "%BASE_FOLDER%dev\*" "%GIT_TEMP%dev\"
    xcopy /ECIHRKY %QUIET_FLAG% "%BASE_FOLDER%mingw64\*" "%GIT_TEMP%mingw64\"
    xcopy /ECIHRKY %QUIET_FLAG% "%BASE_FOLDER%usr\*" "%GIT_TEMP%usr\"
    rem Relaunch from temp folder
    call "%GIT_TEMP%PullUpdates.cmd" %GIT_BRANCH% "%BASE_FOLDER%"
    exit /b 0
) else (
    echo running from tmp folder, target: %BASE_FOLDER%
)


rem echo %~dp0
chdir "%BASE_FOLDER%\.."
set PROJECT_PATH=%CD%
echo %PROJECT_PATH%
cd "%BASE_FOLDER%"


echo %ESC_GREEN%Killing OPE_LMS app if running...%ESC_RESET%
taskkill /f /im OPE_LMS.exe   1>NUL 2>NUL

echo %ESC_GREEN%Stoping any running mgmt apps...%ESC_RESET%
taskkill /f /im mgmt.exe   1>NUL 2>NUL

rem echo checking for local git repo...
if EXIST %PROJECT_PATH%/.git (
  rem echo "Git repo exists..."
) ELSE (
  echo %ESC_GREEN% Initilizing Local Git Repo...
  "%GIT_PATH%" -C "%PROJECT_PATH%" init  >> nul 2>&1
  rem git clean -fd?
  rem We will do a hard reset later and clear all local files
  rem %GIT_PATH% -C "%PROJECT_PATH%" add . >> nul 2>&1
)

echo %ESC_GREEN%Updating Laptop Binaries to the latest update...%ESC_RESET%

rem Add the online origin
"%GIT_PATH%" -C "%PROJECT_PATH%" remote remove ope_origin >> nul 2>&1
"%GIT_PATH%" -C "%PROJECT_PATH%" remote add ope_origin https://github.com/operepo/ope_laptop_binaries.git 
rem >> nul 2>&1

rem Add the offline origin
"%GIT_PATH%" -C "%PROJECT_PATH%" remote remove ope_smc_origin >> nul 2>&1
"%GIT_PATH%" -C "%PROJECT_PATH%" remote add ope_smc_origin %SMC_GIT%/ope_laptop_binaries.git >> nul 2>&1

rem Which origin were we able to pull from?
SET PULL_ORIGIN=ope_origin

rem Try to pull the online origin
echo %ESC_GREEN%trying online git pull...%ESC_RESET%
rem stash save just in case
"%GIT_PATH%" -C "%PROJECT_PATH%" fetch --depth=1 -uf !PULL_ORIGIN! %GIT_BRANCH% 
rem >> nul 2>&1

if !ERRORLEVEL! NEQ 0 (
    rem Failed to pull from the 
    echo.
    echo.
    echo %ESC_YELLOW%Online pull failed, pulling from local smc server%ESC_RESET%
    echo.
    
    SET PULL_ORIGIN=ope_smc_origin
    rem %GIT_PATH% pull !PULL_ORIGIN! %GIT_BRANCH% >> nul 2>&1
    "%GIT_PATH%" -C "%PROJECT_PATH%" fetch --depth=1 -uf !PULL_ORIGIN! %GIT_BRANCH% 
    rem >> nul 2>&1

    
    if !ERRORLEVEL! NEQ 0 (
        echo.
        echo.
        echo %ESC_RED%***** Failed to git pull from local SMC server, You may not have the latest Laptop Software *****%ESC_RESET%
        echo.
        rem echo !PULL_ORIGIN!
        exit /B 2
    ) else (
        echo %ESC_GREEN%-- Updated from local SMC server.%ESC_RESET%
    )
) else (
    echo %ESC_GREEN%-- Updated from online github server.%ESC_RESET%
    
)

rem Force us to the current HEAD (force us to update)
echo %ESC_GREEN%Checking out changes...%ESC_RESET%
rem Remove current master branch
"%GIT_PATH%" -C "%PROJECT_PATH%" branch -d !PULL_ORIGIN!/%GIT_BRANCH%  1>NUL 2>NUL
rem Kill local changes
rem %GIT_PATH% -C "%PROJECT_PATH%" checkout *
"%GIT_PATH%" -C "%PROJECT_PATH%" checkout -f -B %GIT_BRANCH% !PULL_ORIGIN!/%GIT_BRANCH%
rem >> nul 2>&1
rem Reset to current HEAD
"%GIT_PATH%" -C "%PROJECT_PATH%" reset --hard !PULL_ORIGIN!/%GIT_BRANCH%
rem Delete local changed files
rem %GIT_PATH% -C "%PROJECT_PATH%" clean -fdx
rem Checkout current files
"%GIT_PATH%" -C "%PROJECT_PATH%" checkout -f -B %GIT_BRANCH% !PULL_ORIGIN!/%GIT_BRANCH%

if !ERRORLEVEL! NEQ 0 (
    echo.
    echo.
    echo %ESC_RED%***** Error during rebase! You have local changes - Laptop Binaries NOT Updated. *****%ESC_RESET%
    echo.
    exit /B 2
) else (
    echo %ESC_GREEN%Laptop Binaries Update Finished!%ESC_RESET%
)

rem Show current rev
"%GIT_PATH%" -C "%PROJECT_PATH%" rev-parse HEAD

exit /b 0
