/*
 * # Fomantic UI - 2.8.8
 * https://github.com/fomantic/Fomantic-UI
 * http://fomantic-ui.com/
 *
 * Copyright 2022 Contributors
 * Released under the MIT license
 * http://opensource.org/licenses/MIT
 *
 */
!function(B,R,P,W){"use strict";B.isFunction=B.isFunction||function(e){return"function"==typeof e&&"number"!=typeof e.nodeType},R=void 0!==R&&R.Math==Math?R:"undefined"!=typeof self&&self.Math==Math?self:Function("return this")(),B.fn.modal=function(T){var A,e=B(this),H=B(R),D=B(P),O=B("body"),E=e.selector||"",L=(new Date).getTime(),N=[],z=T,j="string"==typeof z,q=[].slice.call(arguments,1),I=R.requestAnimationFrame||R.mozRequestAnimationFrame||R.webkitRequestAnimationFrame||R.msRequestAnimationFrame||function(e){setTimeout(e,0)};return e.each(function(){var o,s,e,i,t,a,c,n,r,l,d=B.isPlainObject(T)?B.extend(!0,{},B.fn.modal.settings,T):B.extend({},B.fn.modal.settings),u=d.selector,m=d.className,f=d.namespace,h=d.fields,g=d.error,p="."+f,v="module-"+f,b=B(this),y=B(d.context),x=b.find(u.close),k=this,w=b.hasClass("modal")?b.data(v):W,C=!1,S="",F="",M={initialize:function(){var s;b.hasClass("modal")||(M.create.modal(),B.isFunction(d.onHidden)||(d.onHidden=function(){M.destroy(),b.remove()})),b.addClass(d.class),""!==d.title&&b.find(u.title).html(M.helpers.escape(d.title,d.preserveHTML)).addClass(d.classTitle),""!==d.content&&b.find(u.content).html(M.helpers.escape(d.content,d.preserveHTML)).addClass(d.classContent),M.has.configActions()&&(0===(s=b.find(u.actions).addClass(d.classActions)).length?s=B("<div/>",{class:m.actions+" "+(d.classActions||"")}).appendTo(b):s.empty(),d.actions.forEach(function(e){var t=e[h.icon]?'<i class="'+M.helpers.deQuote(e[h.icon])+' icon"></i>':"",n=M.helpers.escape(e[h.text]||"",d.preserveHTML),i=M.helpers.deQuote(e[h.class]||""),o=e[h.click]&&B.isFunction(e[h.click])?e[h.click]:function(){};s.append(B("<button/>",{html:t+n,class:m.button+" "+i,click:function(){!1!==o.call(k,b)&&M.hide()}}))})),M.cache={},M.verbose("Initializing dimmer",y),M.create.id(),M.create.dimmer(),d.allowMultiple&&M.create.innerDimmer(),d.centered||b.addClass("top aligned"),M.refreshModals(),M.bind.events(),d.observeChanges&&M.observeChanges(),M.instantiate(),d.autoShow&&M.show()},instantiate:function(){M.verbose("Storing instance of modal"),w=M,b.data(v,w)},create:{modal:function(){b=B("<div/>",{class:m.modal}),d.closeIcon&&(x=B("<i/>",{class:m.close}),b.append(x)),""!==d.title&&B("<div/>",{class:m.title}).appendTo(b),""!==d.content&&B("<div/>",{class:m.content}).appendTo(b),M.has.configActions()&&B("<div/>",{class:m.actions}).appendTo(b),y.append(b)},dimmer:function(){var e={debug:d.debug,dimmerName:"modals"},e=B.extend(!0,e,d.dimmerSettings);B.fn.dimmer===W?M.error(g.dimmer):(M.debug("Creating dimmer"),i=y.dimmer(e),d.detachable?(M.verbose("Modal is detachable, moving content into dimmer"),i.dimmer("add content",b)):M.set.undetached(),t=i.dimmer("get dimmer"))},id:function(){r=(Math.random().toString(16)+"000000000").substr(2,8),n="."+r,M.verbose("Creating unique id for element",r)},innerDimmer:function(){0==b.find(u.dimmer).length&&b.prepend('<div class="ui inverted dimmer"></div>')}},destroy:function(){l&&l.disconnect(),M.verbose("Destroying previous modal"),b.removeData(v).off(p),H.off(n),t.off(n),x.off(p),y.dimmer("destroy")},observeChanges:function(){"MutationObserver"in R&&((l=new MutationObserver(function(e){M.debug("DOM tree modified, refreshing"),M.refresh()})).observe(k,{childList:!0,subtree:!0}),M.debug("Setting up mutation observer",l))},refresh:function(){M.remove.scrolling(),M.cacheSizes(),M.can.useFlex()||M.set.modalOffset(),M.set.screenHeight(),M.set.type()},refreshModals:function(){s=b.siblings(u.modal),o=s.add(b)},attachEvents:function(e,t){var n=B(e);t=B.isFunction(M[t])?M[t]:M.toggle,0<n.length?(M.debug("Attaching modal events to element",e,t),n.off(p).on("click"+p,t)):M.error(g.notFound,e)},bind:{events:function(){M.verbose("Attaching events"),b.on("click"+p,u.close,M.event.close).on("click"+p,u.approve,M.event.approve).on("click"+p,u.deny,M.event.deny),H.on("resize"+n,M.event.resize)},scrollLock:function(){i.get(0).addEventListener("touchmove",M.event.preventScroll,{passive:!1})}},unbind:{scrollLock:function(){i.get(0).removeEventListener("touchmove",M.event.preventScroll,{passive:!1})}},get:{id:function(){return(Math.random().toString(16)+"000000000").substr(2,8)},element:function(){return b},settings:function(){return d}},event:{approve:function(){C||!1===d.onApprove.call(k,B(this))?M.verbose("Approve callback returned false cancelling hide"):(C=!0,M.hide(function(){C=!1}))},preventScroll:function(e){-1!==e.target.className.indexOf("dimmer")&&e.preventDefault()},deny:function(){C||!1===d.onDeny.call(k,B(this))?M.verbose("Deny callback returned false cancelling hide"):(C=!0,M.hide(function(){C=!1}))},close:function(){M.hide()},mousedown:function(e){var t=B(e.target),n=M.is.rtl();(a=0<t.closest(u.modal).length)&&M.verbose("Mouse down event registered inside the modal"),(c=M.is.scrolling()&&(!n&&B(R).outerWidth()-d.scrollbarWidth<=e.clientX||n&&d.scrollbarWidth>=e.clientX))&&M.verbose("Mouse down event registered inside the scrollbar")},mouseup:function(e){if(d.closable)if(a)M.debug("Dimmer clicked but mouse down was initially registered inside the modal");else if(c)M.debug("Dimmer clicked but mouse down was initially registered inside the scrollbar");else{var t=0<B(e.target).closest(u.modal).length,e=B.contains(P.documentElement,e.target);if(!t&&e&&M.is.active()&&b.hasClass(m.front)){if(M.debug("Dimmer clicked, hiding all modals"),d.allowMultiple){if(!M.hideAll())return}else if(!M.hide())return;M.remove.clickaway()}}else M.verbose("Dimmer clicked but closable setting is disabled")},debounce:function(e,t){clearTimeout(M.timer),M.timer=setTimeout(e,t)},keyboard:function(e){27==e.which&&(d.closable?(M.debug("Escape key pressed hiding modal"),b.hasClass(m.front)&&M.hide()):M.debug("Escape key pressed, but closable is set to false"),e.preventDefault())},resize:function(){i.dimmer("is active")&&(M.is.animating()||M.is.active())&&I(M.refresh)}},toggle:function(){M.is.active()||M.is.animating()?M.hide():M.show()},show:function(e){e=B.isFunction(e)?e:function(){},M.refreshModals(),M.set.dimmerSettings(),M.set.dimmerStyles(),M.showModal(e)},hide:function(e){return e=B.isFunction(e)?e:function(){},M.refreshModals(),M.hideModal(e)},showModal:function(e){e=B.isFunction(e)?e:function(){},M.is.animating()||!M.is.active()?(M.showDimmer(),M.cacheSizes(),M.set.bodyMargin(),M.can.useFlex()?M.remove.legacy():(M.set.legacy(),M.set.modalOffset(),M.debug("Using non-flex legacy modal positioning.")),M.set.screenHeight(),M.set.type(),M.set.clickaway(),!d.allowMultiple&&M.others.active()?M.hideOthers(M.showModal):(C=!1,d.allowMultiple&&(M.others.active()&&s.filter("."+m.active).find(u.dimmer).addClass("active"),d.detachable&&b.detach().appendTo(t)),d.onShow.call(k),d.transition&&B.fn.transition!==W&&b.transition("is supported")?(M.debug("Showing modal with css animations"),b.transition({debug:d.debug,animation:(d.transition.showMethod||d.transition)+" in",queue:d.queue,duration:d.transition.showDuration||d.duration,useFailSafe:!0,onComplete:function(){d.onVisible.apply(k),d.keyboardShortcuts&&M.add.keyboardShortcuts(),M.save.focus(),M.set.active(),d.autofocus&&M.set.autofocus(),e()}})):M.error(g.noTransition))):M.debug("Modal is already visible")},hideModal:function(e,t,n){var i=s.filter("."+m.active).last();if(e=B.isFunction(e)?e:function(){},M.debug("Hiding modal"),!1===d.onHide.call(k,B(this)))return M.verbose("Hide callback returned false cancelling hide"),C=!1;(M.is.animating()||M.is.active())&&(d.transition&&B.fn.transition!==W&&b.transition("is supported")?(M.remove.active(),b.transition({debug:d.debug,animation:(d.transition.hideMethod||d.transition)+" out",queue:d.queue,duration:d.transition.hideDuration||d.duration,useFailSafe:!0,onStart:function(){M.others.active()||M.others.animating()||t||M.hideDimmer(),d.keyboardShortcuts&&!M.others.active()&&M.remove.keyboardShortcuts()},onComplete:function(){M.unbind.scrollLock(),d.allowMultiple&&(i.addClass(m.front),b.removeClass(m.front),(n?o:i).find(u.dimmer).removeClass("active")),B.isFunction(d.onHidden)&&d.onHidden.call(k),M.remove.dimmerStyles(),M.restore.focus(),e()}})):M.error(g.noTransition))},showDimmer:function(){i.dimmer("is animating")||!i.dimmer("is active")?(M.save.bodyMargin(),M.debug("Showing dimmer"),i.dimmer("show")):M.debug("Dimmer already visible")},hideDimmer:function(){i.dimmer("is animating")||i.dimmer("is active")?(M.unbind.scrollLock(),i.dimmer("hide",function(){M.restore.bodyMargin(),M.remove.clickaway(),M.remove.screenHeight()})):M.debug("Dimmer is not visible cannot hide")},hideAll:function(n){var i,e=o.filter("."+m.active+", ."+m.animating);if(n=B.isFunction(n)?n:function(){},0<e.length)return M.debug("Hiding all visible modals"),i=!0,B(e.get().reverse()).each(function(e,t){i=i&&B(t).modal("hide modal",n,!1,!0)}),i&&M.hideDimmer(),i},hideOthers:function(e){var t=s.filter("."+m.active+", ."+m.animating);e=B.isFunction(e)?e:function(){},0<t.length&&(M.debug("Hiding other modals",s),t.modal("hide modal",e,!0))},others:{active:function(){return 0<s.filter("."+m.active).length},animating:function(){return 0<s.filter("."+m.animating).length}},add:{keyboardShortcuts:function(){M.verbose("Adding keyboard shortcuts"),D.on("keyup"+p,M.event.keyboard)}},save:{focus:function(){0<B(P.activeElement).closest(b).length||(e=B(P.activeElement).blur())},bodyMargin:function(){S=O.css("margin-"+(M.can.leftBodyScrollbar()?"left":"right"));var e=parseInt(S.replace(/[^\d.]/g,"")),t=R.innerWidth-P.documentElement.clientWidth;F=e+t}},restore:{focus:function(){e&&0<e.length&&d.restoreFocus&&e.focus()},bodyMargin:function(){var n=M.can.leftBodyScrollbar()?"left":"right";O.css("margin-"+n,S),O.find(u.bodyFixed.replace("right",n)).each(function(){var e=B(this),t="fixed"===e.css("position")?"padding-"+n:n;e.css(t,"")})}},remove:{active:function(){b.removeClass(m.active)},legacy:function(){b.removeClass(m.legacy)},clickaway:function(){d.detachable||b.off("mousedown"+n),t.off("mousedown"+n),t.off("mouseup"+n)},dimmerStyles:function(){t.removeClass(m.inverted),i.removeClass(m.blurring)},bodyStyle:function(){""===O.attr("style")&&(M.verbose("Removing style attribute"),O.removeAttr("style"))},screenHeight:function(){M.debug("Removing page height"),O.css("height","")},keyboardShortcuts:function(){M.verbose("Removing keyboard shortcuts"),D.off("keyup"+p)},scrolling:function(){i.removeClass(m.scrolling),b.removeClass(m.scrolling)}},cacheSizes:function(){b.addClass(m.loading);var e=b.prop("scrollHeight"),t=b.outerWidth(),n=b.outerHeight();M.cache.pageHeight!==W&&0===n||(B.extend(M.cache,{pageHeight:B(P).outerHeight(),width:t,height:n+d.offset,scrollHeight:e+d.offset,contextHeight:("body"==d.context?B(R):i).height()}),M.cache.topOffset=-M.cache.height/2),b.removeClass(m.loading),M.debug("Caching modal and container sizes",M.cache)},helpers:{deQuote:function(e){return String(e).replace(/"/g,"")},escape:function(e,t){if(t)return e;var n={"<":"&lt;",">":"&gt;",'"':"&quot;","'":"&#x27;","`":"&#x60;"};return/[&<>"'`]/.test(e)?(e=e.replace(/&(?![a-z0-9#]{1,6};)/,"&amp;")).replace(/[<>"'`]/g,function(e){return n[e]}):e}},can:{leftBodyScrollbar:function(){return M.cache.leftBodyScrollbar===W&&(M.cache.leftBodyScrollbar=M.is.rtl()&&(M.is.iframe&&!M.is.firefox()||M.is.safari()||M.is.edge()||M.is.ie())),M.cache.leftBodyScrollbar},useFlex:function(){return"auto"===d.useFlex?d.detachable&&!M.is.ie():(d.useFlex&&M.is.ie()?M.debug("useFlex true is not supported in IE"):d.useFlex&&!d.detachable&&M.debug("useFlex true in combination with detachable false is not supported"),d.useFlex)},fit:function(){var e=M.cache.contextHeight,t=M.cache.contextHeight/2,n=M.cache.topOffset,i=M.cache.scrollHeight,o=M.cache.height,s=d.padding;return o<i?t+n+i+s<e:o+2*s<e}},has:{configActions:function(){return Array.isArray(d.actions)&&0<d.actions.length}},is:{active:function(){return b.hasClass(m.active)},ie:function(){var e,t;return M.cache.isIE===W&&(e=!R.ActiveXObject&&"ActiveXObject"in R,t="ActiveXObject"in R,M.cache.isIE=e||t),M.cache.isIE},animating:function(){return b.transition("is supported")?b.transition("is animating"):b.is(":visible")},scrolling:function(){return i.hasClass(m.scrolling)},modernBrowser:function(){return!(R.ActiveXObject||"ActiveXObject"in R)},rtl:function(){return M.cache.isRTL===W&&(M.cache.isRTL="rtl"===O.attr("dir")||"rtl"===O.css("direction")),M.cache.isRTL},safari:function(){return M.cache.isSafari===W&&(M.cache.isSafari=/constructor/i.test(R.HTMLElement)||!!R.ApplePaySession),M.cache.isSafari},edge:function(){return M.cache.isEdge===W&&(M.cache.isEdge=!!R.setImmediate&&!M.is.ie()),M.cache.isEdge},firefox:function(){return M.cache.isFirefox===W&&(M.cache.isFirefox=!!R.InstallTrigger),M.cache.isFirefox},iframe:function(){return!(self===top)}},set:{autofocus:function(){var e=b.find("[tabindex], :input").filter(":visible").filter(function(){return 0===B(this).closest(".disabled").length}),t=e.filter("[autofocus]"),t=(0<t.length?t:e).first();0<t.length&&t.focus()},bodyMargin:function(){var n=M.can.leftBodyScrollbar()?"left":"right";(d.detachable||M.can.fit())&&O.css("margin-"+n,F+"px"),O.find(u.bodyFixed.replace("right",n)).each(function(){var e=B(this),t="fixed"===e.css("position")?"padding-"+n:n;e.css(t,"calc("+e.css(t)+" + "+F+"px)")})},clickaway:function(){d.detachable||b.on("mousedown"+n,M.event.mousedown),t.on("mousedown"+n,M.event.mousedown),t.on("mouseup"+n,M.event.mouseup)},dimmerSettings:function(){var e;B.fn.dimmer===W?M.error(g.dimmer):(e={debug:d.debug,dimmerName:"modals",closable:"auto",useFlex:M.can.useFlex(),duration:{show:d.transition.showDuration||d.duration,hide:d.transition.hideDuration||d.duration}},e=B.extend(!0,e,d.dimmerSettings),d.inverted&&(e.variation=e.variation!==W?e.variation+" inverted":"inverted"),y.dimmer("setting",e))},dimmerStyles:function(){d.inverted?t.addClass(m.inverted):t.removeClass(m.inverted),d.blurring?i.addClass(m.blurring):i.removeClass(m.blurring)},modalOffset:function(){var e;d.detachable?b.css({marginTop:!b.hasClass("aligned")&&M.can.fit()?-M.cache.height/2:d.padding/2,marginLeft:-M.cache.width/2}):(e=M.can.fit(),b.css({top:!b.hasClass("aligned")&&e?B(P).scrollTop()+(M.cache.contextHeight-M.cache.height)/2:!e||b.hasClass("top")?B(P).scrollTop()+d.padding:B(P).scrollTop()+(M.cache.contextHeight-M.cache.height-d.padding),marginLeft:-M.cache.width/2})),M.verbose("Setting modal offset for legacy mode")},screenHeight:function(){M.can.fit()?O.css("height",""):b.hasClass("bottom")||(M.debug("Modal is taller than page content, resizing page height"),O.css("height",M.cache.height+2*d.padding))},active:function(){b.addClass(m.active+" "+m.front),s.filter("."+m.active).removeClass(m.front)},scrolling:function(){i.addClass(m.scrolling),b.addClass(m.scrolling),M.unbind.scrollLock()},legacy:function(){b.addClass(m.legacy)},type:function(){M.can.fit()?(M.verbose("Modal fits on screen"),M.others.active()||M.others.animating()||(M.remove.scrolling(),M.bind.scrollLock())):b.hasClass("bottom")?M.verbose("Bottom aligned modal not fitting on screen is unsupported for scrolling"):(M.verbose("Modal cannot fit on screen setting to scrolling"),M.set.scrolling())},undetached:function(){i.addClass(m.undetached)}},setting:function(e,t){if(M.debug("Changing setting",e,t),B.isPlainObject(e))B.extend(!0,d,e);else{if(t===W)return d[e];B.isPlainObject(d[e])?B.extend(!0,d[e],t):d[e]=t}},internal:function(e,t){if(B.isPlainObject(e))B.extend(!0,M,e);else{if(t===W)return M[e];M[e]=t}},debug:function(){!d.silent&&d.debug&&(d.performance?M.performance.log(arguments):(M.debug=Function.prototype.bind.call(console.info,console,d.name+":"),M.debug.apply(console,arguments)))},verbose:function(){!d.silent&&d.verbose&&d.debug&&(d.performance?M.performance.log(arguments):(M.verbose=Function.prototype.bind.call(console.info,console,d.name+":"),M.verbose.apply(console,arguments)))},error:function(){d.silent||(M.error=Function.prototype.bind.call(console.error,console,d.name+":"),M.error.apply(console,arguments))},performance:{log:function(e){var t,n;d.performance&&(n=(t=(new Date).getTime())-(L||t),L=t,N.push({Name:e[0],Arguments:[].slice.call(e,1)||"",Element:k,"Execution Time":n})),clearTimeout(M.performance.timer),M.performance.timer=setTimeout(M.performance.display,500)},display:function(){var e=d.name+":",n=0;L=!1,clearTimeout(M.performance.timer),B.each(N,function(e,t){n+=t["Execution Time"]}),e+=" "+n+"ms",E&&(e+=" '"+E+"'"),(console.group!==W||console.table!==W)&&0<N.length&&(console.groupCollapsed(e),console.table?console.table(N):B.each(N,function(e,t){console.log(t.Name+": "+t["Execution Time"]+"ms")}),console.groupEnd()),N=[]}},invoke:function(i,e,t){var o,s,n,a=w;return e=e||q,t=k||t,"string"==typeof i&&a!==W&&(i=i.split(/[\. ]/),o=i.length-1,B.each(i,function(e,t){var n=e!=o?t+i[e+1].charAt(0).toUpperCase()+i[e+1].slice(1):i;if(B.isPlainObject(a[n])&&e!=o)a=a[n];else{if(a[n]!==W)return s=a[n],!1;{if(!B.isPlainObject(a[t])||e==o)return a[t]!==W&&(s=a[t]),!1;a=a[t]}}})),B.isFunction(s)?n=s.apply(t,e):s!==W&&(n=s),Array.isArray(A)?A.push(n):A!==W?A=[A,n]:n!==W&&(A=n),s}};j?(w===W&&(B.isFunction(d.templates[z])&&(d.autoShow=!0,d.className.modal=d.className.template,d=B.extend(!0,{},d,d.templates[z].apply(M,q)),m=d.className,d.namespace,h=d.fields,g=d.error),M.initialize()),B.isFunction(d.templates[z])||M.invoke(z)):(w!==W&&w.invoke("destroy"),M.initialize(),A=b)}),A!==W?A:this},B.fn.modal.settings={name:"Modal",namespace:"modal",useFlex:"auto",offset:0,silent:!1,debug:!1,verbose:!1,performance:!0,observeChanges:!1,allowMultiple:!1,detachable:!0,closable:!0,autofocus:!0,restoreFocus:!0,autoShow:!1,inverted:!1,blurring:!1,centered:!0,dimmerSettings:{closable:!1,useCSS:!0},keyboardShortcuts:!0,context:"body",queue:!1,duration:500,transition:"scale",padding:50,scrollbarWidth:10,title:"",content:"",class:"",classTitle:"",classContent:"",classActions:"",closeIcon:!1,actions:!1,preserveHTML:!0,fields:{class:"class",text:"text",icon:"icon",click:"click"},onShow:function(){},onVisible:function(){},onHide:function(){return!0},onHidden:!1,onApprove:function(){return!0},onDeny:function(){return!0},selector:{title:"> .header",content:"> .content",actions:"> .actions",close:"> .close",approve:".actions .positive, .actions .approve, .actions .ok",deny:".actions .negative, .actions .deny, .actions .cancel",modal:".ui.modal",dimmer:"> .ui.dimmer",bodyFixed:"> .ui.fixed.menu, > .ui.right.toast-container, > .ui.right.sidebar, > .ui.fixed.nag, > .ui.fixed.nag > .close",prompt:".ui.input > input"},error:{dimmer:"UI Dimmer, a required component is not included in this page",method:"The method you called is not defined.",notFound:"The element you specified could not be found"},className:{active:"active",animating:"animating",blurring:"blurring",inverted:"inverted",legacy:"legacy",loading:"loading",scrolling:"scrolling",undetached:"undetached",front:"front",close:"close icon",button:"ui button",modal:"ui modal",title:"header",content:"content",actions:"actions",template:"ui tiny modal",ok:"positive",cancel:"negative",prompt:"ui fluid input"},text:{ok:"Ok",cancel:"Cancel"}},B.fn.modal.settings.templates={getArguments:function(e){e=[].slice.call(e);return B.isPlainObject(e[0])?B.extend({handler:function(){},content:"",title:""},e[0]):(B.isFunction(e[e.length-1])||e.push(function(){}),{handler:e.pop(),content:e.pop()||"",title:e.pop()||""})},alert:function(){var e=this.get.settings(),t=e.templates.getArguments(arguments);return{title:t.title,content:t.content,actions:[{text:e.text.ok,class:e.className.ok,click:t.handler}]}},confirm:function(){var e=this.get.settings(),t=e.templates.getArguments(arguments);return{title:t.title,content:t.content,actions:[{text:e.text.ok,class:e.className.ok,click:function(){t.handler(!0)}},{text:e.text.cancel,class:e.className.cancel,click:function(){t.handler(!1)}}]}},prompt:function(){var t=this,e=this.get.settings(),n=e.templates.getArguments(arguments);return 0===B(B.parseHTML(n.content)).filter(".ui.input").length&&(n.content+='<p><div class="'+e.className.prompt+'"><input placeholder="'+this.helpers.deQuote(n.placeholder||"")+'" type="text" value="'+this.helpers.deQuote(n.defaultValue||"")+'"></div></p>'),{title:n.title,content:n.content,actions:[{text:e.text.ok,class:e.className.ok,click:function(){var e=t.get.settings(),e=t.get.element().find(e.selector.prompt)[0];n.handler(B(e).val())}},{text:e.text.cancel,class:e.className.cancel,click:function(){n.handler(null)}}]}}}}(jQuery,window,document);